CREATE OR REPLACE FUNCTION ADDCONST() 
RETURNS VOID AS 
$BODY$ 
BEGIN 
    IF  EXISTS (SELECT 1 FROM INFORMATION_SCHEMA.CONSTRAINT_TABLE_USAGE
                    WHERE TABLE_NAME ILIKE 'EST_ORC_GLB_MEDICO' 
                    AND CONSTRAINT_NAME ILIKE 'EST_ORC_GLB_MEDICO_PKEY'
				) THEN 
		ALTER TABLE EST_ORC_GLB_MEDICO DROP CONSTRAINT EST_ORC_GLB_MEDICO_PKEY;
        RAISE NOTICE 'EST_ORC_GLB_MEDICO_PKEY REMOVIDA.';
	END IF; 
	
	
	
	ALTER TABLE EST_ORC_GLB_MEDICO ADD CONSTRAINT EST_ORC_GLB_MEDICO_PKEY UNIQUE (CD_EMP, CD_FILIAL, CD_PROD, NR_ORC, DT_CAD, CD_IT);
	RAISE NOTICE 'CONSTRAINT EST_ORC_GLB_MEDICO_PKEY RECRIADA NA TABELA EST_ORC_GLB_MEDICO.'; 
    
       
END; 
-- FIM BLOCO PRINCIPAL 
$BODY$ 
LANGUAGE PLPGSQL VOLATILE 
  COST 100; 
ALTER FUNCTION ADDCONST() OWNER TO POSTGRES; 
SELECT ADDCONST(); 


